/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.workers;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.SwingWorker;
import net.ftb.data.Settings;
import net.ftb.log.Logger;
import net.ftb.util.Benchmark;

public class UnreadNewsWorker
extends SwingWorker<Integer, Void> {
    @Override
    protected Integer doInBackground() {
        Benchmark.start("UnreadNews");
        int i = 0;
        try {
            String[] str;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new URL("http://launcher.feed-the-beast.com/newsupdate.php").openStream()));
            ArrayList<Long> timeStamps = Lists.newArrayList();
            String s = reader.readLine();
            s = s.trim();
            for (String aStr : str = s.split(",")) {
                if (timeStamps.contains(Long.parseLong(aStr))) continue;
                timeStamps.add(Long.parseLong(aStr));
            }
            long l = Long.parseLong(Settings.getSettings().getNewsDate()) == 0L ? Long.parseLong(Settings.getSettings().getNewsDate()) : Long.parseLong(Settings.getSettings().getNewsDate().substring(0, 10));
            for (Long timeStamp : timeStamps) {
                long time = timeStamp;
                if (time <= l) continue;
                ++i;
            }
            Benchmark.logBenchAs("UnreadNews", "UnreadNews Init");
        }
        catch (UnknownHostException e) {
            Logger.logWarn("Error while checking news: " + e.getMessage());
        }
        catch (Exception e) {
            Logger.logError("Error while checking news", e);
        }
        return i;
    }
}

